/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import de.edpan.engine.net.IPRouting;
import de.edpan.engine.net.impl.IPRefreshException;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AdminController {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private IPRouting ipRouting;

    @RequestMapping(value={"refreshIPAccesses"}, method={RequestMethod.GET})
    public ResponseEntity<Void> refreshIPAccesses(Model model, HttpServletRequest req) {
        model.addAttribute("isAdmin", (Object)true);
        try {
            this.ipRouting.refreshIP();
            LOG.info((Object)"ip routing refreshed");
            model.addAttribute("refreshSuccess", (Object)Boolean.TRUE);
        }
        catch (IPRefreshException ipre) {
            model.addAttribute("refreshSuccess", (Object)Boolean.FALSE);
            model.addAttribute("errorMessage", (Object)ipre.getErrorAsString());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            model.addAttribute("refreshSuccess", (Object)Boolean.FALSE);
            model.addAttribute("errorMessage", (Object)e.getMessage());
        }
        return null;
    }

    @RequestMapping(value={"admin"}, method={RequestMethod.GET})
    public String resetPassword(Model model, HttpServletRequest req) {
        model.addAttribute("isAdmin", (Object)req.isUserInRole("ADMIN"));
        return "admin";
    }
}

