/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources"})
public class ResourceController {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Value(value="${genoa.products.datadir}")
    private File productsDataDir;
    @Value(value="${genoa.resources}")
    private File resourcesDir;
    private CacheControl cacheControl = CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.MINUTES);

    @RequestMapping(value={"**"})
    public ResponseEntity<byte[]> getResources(HttpServletRequest req) throws FileNotFoundException, IOException {
        File f;
        String dir;
        String uri = req.getRequestURI();
        uri = StringUtils.substringAfter((String)uri, (String)"resources/");
        switch (dir = uri.split("/")[0]) {
            case "messages": 
            case "templates": {
                f = new File(this.resourcesDir, uri);
                break;
            }
            default: {
                f = new File(this.productsDataDir, uri);
            }
        }
        byte[] byteArray = null;
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                ResponseEntity responseEntity;
                try (BufferedInputStream bis = new BufferedInputStream(fis);){
                    byteArray = IOUtils.toByteArray((InputStream)bis);
                    Optional mediaType = MediaTypeFactory.getMediaType((String)uri);
                    ResponseEntity.BodyBuilder response = ResponseEntity.ok().contentLength((long)byteArray.length);
                    if (mediaType.isPresent()) {
                        response = response.contentType((MediaType)mediaType.get());
                    }
                    responseEntity = ((ResponseEntity.BodyBuilder)response.cacheControl(this.cacheControl)).body((Object)byteArray);
                }
                return responseEntity;
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

