/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.service.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.edpan.engine.product.ProductActivation;
import de.edpan.engine.user.AccessController;
import de.edpan.engine.user.RegistrationManager;
import de.edpan.engine.user.User;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class AutoRenewalController {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private RegistrationManager registrationManager;
    @Resource
    private AccessController accessController;
    private SimpleDateFormat sdf;

    @PostConstruct
    private void init() {
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/autorenewal.html"}, method={RequestMethod.POST})
    protected void doAutoRenewal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        HashMap<String, Object> responseData;
        ObjectMapper om;
        block5: {
            StringWriter sw = new StringWriter();
            IOUtils.copy((Reader)req.getReader(), (Writer)sw);
            LOG.info((Object)sw);
            om = new ObjectMapper();
            ObjectNode requestData = (ObjectNode)om.readTree(sw.toString());
            responseData = new HashMap<String, Object>();
            try {
                String productKey = requestData.get("productKey").asText();
                String oldLicence = requestData.get("oldLicence").asText();
                String newLicence = requestData.get("newLicence").asText();
                String language = requestData.get("language").asText();
                Map autoRenewal = this.registrationManager.autoRenewal(productKey, oldLicence, newLicence, language);
                Integer status = (Integer)autoRenewal.get("responseCode");
                responseData.put("status", status);
                if (status != 100) break block5;
                User user = (User)autoRenewal.get("user");
                ProductActivation accessibleProduct = this.accessController.getAccessibleProduct(user, productKey);
                Calendar endingAt = accessibleProduct.getEndingAt();
                SimpleDateFormat simpleDateFormat = this.sdf;
                synchronized (simpleDateFormat) {
                    responseData.put("endingAt", this.sdf.format(endingAt.getTime()));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                responseData.put("error.message", e.getMessage());
                responseData.put("status", 500);
            }
        }
        String response = om.writeValueAsString(responseData);
        LOG.info((Object)response);
        res.getWriter().write(response);
    }
}

