<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	 
	<!-- using us-ascii encoding because special characters like &#49; would be 
		 replaced during transformation when using UTF-8 -->
	<xsl:output method="html" encoding="us-ascii" doctype-public="-//W3C//DTDXHTML 1.0 Transitional//EN" doctype-system="https://www.w3.org/TR/html4/strict.dtd" />
	
    <!-- string parameters -->	
    <xsl:param name="view.details.headimage"/>		
	<xsl:param name="view.details.base"/>
	<xsl:param name="view.details.id"/>
	<xsl:param name="view.details.section"/>
	<xsl:param name="tooltip-xml"/>	
	<xsl:param name="historyHasPrevious"/>
	<xsl:param name="historyHasNext"/>
			
	<xsl:template match="ENTRY">	
		<xsl:text>
		<script>
function setZoomIn(el) {
           var origin = "0% 0% 0px";
           var classOut = "TabB";
           var classIn = "TabB";
           var titleOut = "Zoom Out";
           var titleIn = " Zoom In";
           var width = el.getAttribute("style");
	   width = width.replace(/width:[ ]*/, "");
	   width = width.replace(/; transform: scale\([0-9\.]+\); transform-origin: 0% 0% 0px;/, "");
           if (width == "95%") {
               zoom = 1.2;
               wid = "80%";
              }
           if (width == "80%") {
               zoom = 1.4;
               wid = "70%";
              }
            if (width == "70%") {
               zoom = 1.6;
               wid = "60%";
               classIn = "TabD";
               titleIn = "";
               }
            if (width == "60%") {
               zoom = 1.6;
               wid = "60%";
               classIn = "TabD";
               titleIn = "";
               }
            s = "scale(" + zoom + ")";
	    el.style["transform"] = s;
	    el.style["transformOrigin"] = origin;
	    el.style["webkitTransform"] = s;
	    el.style["webkitTransformOrigin"] = origin;
	    el.style["width"] = wid;
	    document.getElementById("zoomin").className = classIn;
	    document.getElementById("zoomout").className = classOut;
	    document.getElementById("zoomin").title = titleIn;
	    document.getElementById("zoomout").title = titleOut;
}
function setZoomOut(el) {
           var origin = "0% 0% 0px";
           var classOut = "TabB";
           var classIn = "TabB";
           var titleOut = "Zoom Out";
           var titleIn = " Zoom In";
           var width = el.getAttribute("style");
	   width = width.replace(/width:[ ]*/, "");
	   width = width.replace(/; transform: scale\([0-9\.]+\); transform-origin: 0% 0% 0px;/, "");
            if (width == "95%") {
               zoom = 1;
               wid = "95%";
               classOut = "TabD";
               titleOut = "";
               }
            if (width == "80%") {
               zoom = 1;
               wid = "95%";
               classOut = "TabD";
               titleOut = "";
               }
            if (width == "70%") {
               zoom = 1.2;
               wid = "80%";
               }
            if (width == "60%") {
               zoom = 1.4;
               wid = "70%";
               }
            s = "scale(" + zoom + ")";
	    el.style["transform"] = s;
	    el.style["transformOrigin"] = origin;
	    el.style["webkitTransform"] = s;
	    el.style["webkitTransformOrigin"] = origin;
	    el.style["width"] = wid;
	    document.getElementById("zoomin").className = classIn;
	    document.getElementById("zoomout").className = classOut;
	    document.getElementById("zoomin").title = titleIn;
	    document.getElementById("zoomout").title = titleOut;
}
		</script>
		</xsl:text>
			<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%; padding:0; margin:0">
	<tr>
		<td class="Fascia" valign="top" align="center">I QUATTRO CODICI HOEPLI</td>
	</tr>
	<tr>				
		<td valign="top" height="100%">
			<xsl:apply-templates select="HEAD" />
		<div class="Entry" id="entry" style="width:95%">
			<xsl:apply-templates select="BODY" />
		</div>
		</td>
	</tr>
	</table>
	</xsl:template>

	<xsl:template match="HEAD">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="BODY">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="Header">
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="IdxTit">
		<P class="IdxTit"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="Title">
		<P class="Title"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="SubTitle">
		<P class="SubTitle"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="Note">
		<P class="Note"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="Note1">
		<P class="Note1"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="ParaRif">
		<P class="ParaRif"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="Para">
		<P class="Para"><xsl:apply-templates /></P>
	</xsl:template>
	<xsl:template match="Idx">
		<P class="Idx">
		<xsl:if test="string-length(@Link) &gt; 0">
		<xsl:variable name="link"><xsl:value-of select="@Link"/></xsl:variable>
		<a href="javascript:detail('{$link}')" class="textlink">• <xsl:apply-templates /></a>
		</xsl:if>
		</P>
	</xsl:template>
	<xsl:template match="Line">
<xsl:if test="(@LinkIdx != '')">
<div class="sticky">
		<table class="Pulsantiera"><tr>
		<td class="Line">&#9658;&#160;<xsl:apply-templates /></td>
		<td class="button">
			<a class="TabB2" href="javascript:goTop()" title=" Inizio del documento ">T</a>
		</td>
		<td class="button" id="navPreviousEnabled">
			<a class="TabB" href="javascript:loadPreviousEntry()"  title=" Indietro nella cronologia dei documenti visualizzati " id="hprev">←</a>
		</td>
		<td class="button" id="navPreviousDisabled" style="display:none"><span class="TabD">←</span></td>
	<xsl:choose>
		<xsl:when test="string-length(@LinkPrec) &gt; 0">
			<xsl:variable name="linkp"><xsl:value-of select="@LinkPrec"/></xsl:variable>
			<td class="button">
			<a class="TabB2" href="javascript:detail('{$linkp}')" title=" Precedente nell'opera ">↑</a>
			</td>
		</xsl:when>
		<xsl:otherwise>
			<td class="button"><span class="TabD2">↑</span></td>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="string-length(@LinkIdx) &gt; 0">
			<xsl:variable name="linkx"><xsl:value-of select="@LinkIdx"/></xsl:variable>
			<td class="button">
			<a class="TabB2" href="javascript:detail('{$linkx}')" title=" Indice della sezione o del capitolo ">⌂</a>
			</td>
		</xsl:when>
		<xsl:otherwise>
			<td class="button"><span class="TabD2">⌂</span></td>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:choose>
		<xsl:when test="string-length(@LinkSucc) &gt; 0">
			<td class="button">
			<xsl:variable name="links"><xsl:value-of select="@LinkSucc"/></xsl:variable>
			<a class="TabB2" href="javascript:detail('{$links}')" title=" Successivo nell'opera ">↓</a>
			</td>
		</xsl:when>
		<xsl:otherwise>
			<td class="button"><span class="TabD2">↓</span></td>
		</xsl:otherwise>
	</xsl:choose>
		<td class="button" id="navNextEnabled">
			<a class="TabB" href="javascript:loadNextEntry()" id="hnext" title=" Avanti nella cronologia dei documenti visualizzati ">→</a>
		</td>
		<td class="button" id="navNextDisabled" style="display:none"><span class="TabD">→</span></td>
	<td class="button">
		<a class="TabB" onclick="setZoomIn(document.getElementById('entry')); return false" id="zoomin" title=" Zoom In ">Z+</a>
	</td>
	<td class="button">
		<a class="TabD" onclick="setZoomOut(document.getElementById('entry')); return false" id="zoomout" title="">Z–</a>
	</td>
	<xsl:if test="string-length(@LinkId) &gt; 0">
		<xsl:variable name="linkp"><xsl:value-of select="@LinkId"/></xsl:variable>
		<td class="button">
			<a class="TabB2" href="javascript:loadPreferite('{$linkp}')" id="pref" title=" Inserisci la voce nei Preferiti ">♥</a>
		</td>
	</xsl:if>
	</tr></table></div>
</xsl:if>
<xsl:if test="not(@LinkIdx)">
	<table class="Pulsantiera"><tr>
		<td class="LineIdx"><xsl:apply-templates /></td>
	</tr></table>
</xsl:if>
	</xsl:template>
	<xsl:template match="br">
		<br class="rigavuota"></br>
	</xsl:template>
	<xsl:template match="Table">
		<span class="Table">
		<xsl:if test="string-length(@ExtLink) &gt; 0">
			<xsl:variable name="filename"><xsl:value-of select="@ExtLink"/></xsl:variable>
			<a href="hp4c/external/pdf/{$filename}" target="_pdf" class="textlink"><xsl:apply-templates /></a>
		</xsl:if>
		</span>
	</xsl:template>

	<!-- Character replacments -->
	<xsl:template match="NumArt">
		<span class="NumArt"><xsl:apply-templates /></span>
	</xsl:template>
	<xsl:template match="Art">
		<span class="Art"><xsl:apply-templates /></span>
	</xsl:template>
	<xsl:template match="Keyword">
		<!-- Ignore -->
	</xsl:template>
	<xsl:template match="Article">
		<!-- Ignore -->
	</xsl:template>
	<xsl:template match="Year">
		<!-- Ignore -->
	</xsl:template>
	<xsl:template match="Number">
		<!-- Ignore -->
	</xsl:template>
	<xsl:template match="Type">
		<!-- Ignore -->
	</xsl:template>
	<xsl:template match="HL">
		<xsl:variable name="hlidx1"><xsl:value-of select="attribute::index"/></xsl:variable>
		<xsl:variable name="nodeName" select="name()"></xsl:variable>
		<xsl:variable name="hlidx2"><xsl:value-of select="count(preceding::node()[name() = $nodeName]) + 1"/></xsl:variable>
		<a name="hl_{$hlidx1}_{$hlidx2}_{$view.details.id}"></a>
		<span class="HL"><xsl:apply-templates /></span>
	</xsl:template>
	<xsl:template match="TT">
		<!--  <xsl:variable name="tt"><xsl:value-of select="."/></xsl:variable> -->
		<!--  <span onmouseover="return escape('This is a test')" title="{$tt}" alt="{$tt}"><xsl:apply-templates /></span>  -->
		<!--  <span onclick="alert('{$tt}')"><xsl:apply-templates /></span> -->
		<span class="tt"><xsl:apply-templates /></span>
	</xsl:template>
	<xsl:template match="b">
		<b><xsl:apply-templates /></b>
	</xsl:template>	
	<xsl:template match="i">
		<i><xsl:apply-templates /></i>
	</xsl:template>	
	<xsl:template match="sup">
		<sup><xsl:apply-templates /></sup>
	</xsl:template>	
	<xsl:template match="Hword">
		<!-- ignore -->
	</xsl:template>	

</xsl:stylesheet>
