/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.config;

import java.io.File;
import java.util.Locale;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.filter.ShallowEtagHeaderFilter;

@Configuration
public class GeneralConfiguration {
    @Value(value="${genoa.resources}")
    private File resourceDir;

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("file:" + this.resourceDir + File.separator + "messages" + File.separator + "backend" + File.separator + "messages");
        messageSource.setCacheSeconds(60);
        return messageSource;
    }

    @Bean
    public Locale defaultLocale() {
        return Locale.ITALIAN;
    }

    @Bean
    public FilterRegistrationBean<ShallowEtagHeaderFilter> shallowEtagHeaderFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new ShallowEtagHeaderFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/resources/*"});
        filterRegistrationBean.setName("etagFilter");
        return filterRegistrationBean;
    }
}

