/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.service.util.UserHelper;
import com.elexico.genoa.rest.api.AccessibleProductsApi;
import com.elexico.genoa.rest.model.AccessibleProduct;
import de.edpan.engine.model.SerialNumber;
import de.edpan.engine.product.ProductActivation;
import de.edpan.engine.product.ProductInfo;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.user.AccessController;
import de.edpan.engine.user.User;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.NoResultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class AccessibleProductsController
implements AccessibleProductsApi {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private AccessController accessController;
    @Resource
    private UserHelper userHelper;
    @Resource
    private ProductManager productManager;

    public ResponseEntity<List<AccessibleProduct>> accessibleProducts(String userLogin) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        ResponseEntity response = null;
        if (!userLogin.equals(authentication.getPrincipal())) {
            response = new ResponseEntity(HttpStatus.FORBIDDEN);
        } else {
            try {
                User user = this.userHelper.getUser(userLogin);
                ProductActivation[] accessibleProducts = this.accessController.getAccessibleProducts(user);
                if (accessibleProducts != null) {
                    ArrayList<AccessibleProduct> retVal = new ArrayList<AccessibleProduct>(accessibleProducts.length);
                    for (ProductActivation pa : accessibleProducts) {
                        AccessibleProduct ap = new AccessibleProduct();
                        ap.active(Boolean.valueOf(pa.isActive()));
                        ap.setStartingFrom(this.toLocalDate(pa.getStartingFrom()));
                        ap.setEndingAt(this.toLocalDate(pa.getEndingAt()));
                        ap.setProductId(pa.getProductKey());
                        ProductInfo productInfo = this.productManager.getProductInfo(pa.getProductKey());
                        Integer sortOrder = productInfo != null ? productInfo.getSortOrder() : 1000;
                        ap.setSortOrder(sortOrder);
                        SerialNumber serialNumber = pa.getSerialNumber();
                        if (serialNumber != null) {
                            ap.setSerialNumber(serialNumber.getSerialNumber());
                        }
                        retVal.add(ap);
                    }
                    response = ResponseEntity.ok().body(retVal);
                }
            }
            catch (NoResultException nre) {
                response = new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response = new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return response;
    }

    private LocalDate toLocalDate(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        LocalDate ld = LocalDate.of(year, month + 1, day);
        return ld;
    }
}

