/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.security.electron.ElectronAuthentication;
import com.elexico.genoa.backend.service.DetailEntryService;
import com.elexico.genoa.backend.service.util.UserHelper;
import com.elexico.genoa.rest.api.Detail2Api;
import com.elexico.genoa.rest.api.DetailApi;
import com.elexico.genoa.rest.model.AdvancedQuery;
import com.elexico.genoa.rest.model.DetailEntry;
import com.elexico.genoa.rest.model.InterfaceLanguage;
import de.edpan.engine.journal.JournalManager;
import de.edpan.engine.product.ProductActivation;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.Query;
import de.edpan.engine.user.AccessController;
import de.edpan.engine.user.AuthenticationException;
import de.edpan.engine.user.RegistrationManager;
import de.edpan.engine.user.User;
import de.edpan.engine.user.UserContextSession;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;

@RestController
@RequestMapping(value={"/rest"})
public class DetailController
implements DetailApi,
Detail2Api {
    private Map<InterfaceLanguage, Locale> languages;
    @Resource
    private JournalManager journalManager;
    @Resource
    private RegistrationManager registrationManager;
    @Resource
    private ProductManager productManager;
    @Resource
    private UserContextSession userContextSession;
    @Resource
    private AccessController accessController;
    @Resource
    private DetailEntryService detailEntryService;
    @Resource
    UserHelper userHelper;

    @PostConstruct
    private void init() {
        this.languages = new HashMap();
        for (InterfaceLanguage il : InterfaceLanguage.values()) {
            this.languages.put(il, new Locale(il.toString().toLowerCase()));
        }
    }

    @PreAuthorize(value="@accessService.hasAccess(#productId)")
    public ResponseEntity<DetailEntry> showDetailyById(String productId, String entryId, InterfaceLanguage interfaceLanguage) {
        ResponseEntity checkAccess = this.checkAccess(productId);
        if (checkAccess != null) {
            return checkAccess;
        }
        Optional detailEntry = this.detailEntryService.getDetailEntry(productId, entryId, null, null, new Locale(interfaceLanguage.toString()));
        if (detailEntry.isPresent()) {
            this.journalManager.addDetailView(((DetailEntry)detailEntry.get()).getId());
            return ResponseEntity.ok().body((Object)((DetailEntry)detailEntry.get()));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<DetailEntry> showDetailyByAdv(@Valid AdvancedQuery advancedQuery) {
        ResponseEntity checkAccess = this.checkAccess(advancedQuery.getProductId());
        if (checkAccess != null) {
            return checkAccess;
        }
        Query q = new Query();
        Map searchFields = advancedQuery.getSearchFields();
        for (String key : searchFields.keySet()) {
            q.putQueryOption(key, (String)searchFields.get(key));
        }
        q.putQueryOption("ID", advancedQuery.getFieldId());
        Locale locale = (Locale)this.languages.get(advancedQuery.getInterfaceLanguage());
        Optional detailEntry = this.detailEntryService.getDetailEntry(advancedQuery.getProductId(), advancedQuery.getFieldId(), null, q, locale);
        if (detailEntry.isPresent()) {
            this.journalManager.addDetailView(((DetailEntry)detailEntry.get()).getId());
            return ResponseEntity.ok().body((Object)((DetailEntry)detailEntry.get()));
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    private ResponseEntity<DetailEntry> checkAccess(String productId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof ElectronAuthentication) {
            return null;
        }
        String currentPrincipalName = authentication.getName();
        try {
            User user = this.userHelper.getUser(currentPrincipalName);
            this.userContextSession.setUser(user);
            this.userContextSession.setProducts(Arrays.asList(this.accessController.getAccessibleProducts(user)));
            this.productManager.setProductContext(productId);
            ProductActivation productActivation = this.userContextSession.getProductActivation();
            if (!this.registrationManager.checkAccessCount(productActivation)) {
                return ResponseEntity.status((int)440).build();
            }
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }
}

