/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.security.electron.ApplicationState;
import com.elexico.genoa.rest.api.AppStateApi;
import com.elexico.genoa.rest.model.AppState;
import com.elexico.genoa.rest.model.MailRegistrationData;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class ElectronLicenseStateController
implements AppStateApi {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private AppState.AppStateErrorEnum appStateError;
    @Resource
    private ApplicationState applicationState;

    public ResponseEntity<AppState> appStateGet() {
        AppState retVal = new AppState();
        retVal.canActivate(Boolean.valueOf(false));
        retVal.canDeactivate(Boolean.valueOf(false));
        if (this.appStateError != null) {
            retVal.setAppStateError(this.appStateError);
            retVal.setCommand(AppState.CommandEnum.ABORT);
            retVal.setFlow(AppState.FlowEnum.REQUIRED);
        } else if (!this.applicationState.needsSerial()) {
            retVal.command(AppState.CommandEnum.NONE);
        } else if (!this.applicationState.hasSerial()) {
            retVal.command(AppState.CommandEnum.SEND_SERIAL);
            retVal.flow(AppState.FlowEnum.REQUIRED);
        } else if (!this.applicationState.isLockDataValid()) {
            retVal.setCommand(AppState.CommandEnum.ABORT);
            retVal.setFlow(AppState.FlowEnum.REQUIRED);
        } else if (this.applicationState.isTestLicense()) {
            if (this.applicationState.isTestPeriodExpired()) {
                retVal.command(AppState.CommandEnum.SEND_LICENSE_UPGRADE);
                retVal.flow(AppState.FlowEnum.REQUIRED);
            } else {
                ApplicationState.GracePeriod gp = this.applicationState.testPeriodRemaining();
                retVal.setGracePeriod(Integer.valueOf(gp.getTotal()));
                retVal.setGracePeriodRemaining(Integer.valueOf(gp.getRemaning()));
                retVal.command(AppState.CommandEnum.CONFIRM_TEST);
                retVal.flow(AppState.FlowEnum.OPTIONAL);
            }
        } else if (this.applicationState.needsActivation()) {
            retVal.command(AppState.CommandEnum.CONFIRM_ACTIVATION);
            retVal.canActivate(Boolean.valueOf(true));
            ApplicationState.GracePeriod gracePeriod = this.applicationState.gracePeriod();
            retVal.flow(gracePeriod.getRemaning() < 0 ? AppState.FlowEnum.REQUIRED : AppState.FlowEnum.OPTIONAL);
            retVal.setGracePeriod(Integer.valueOf(gracePeriod.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gracePeriod.getRemaning()));
        } else {
            retVal.command(AppState.CommandEnum.NONE);
            retVal.canActivate(Boolean.valueOf(false));
            retVal.canDeactivate(Boolean.valueOf(true));
        }
        return ResponseEntity.ok((Object)retVal);
    }

    public ResponseEntity<AppState> appStateSerialPost(String serial) {
        AppState retVal = this.applicationState.processSerialNumber(serial);
        if (retVal != null) {
            return ResponseEntity.ok((Object)retVal);
        }
        return this.appStateGet();
    }

    public ResponseEntity<AppState> appStateUsernameEmailCompanyPost(String username, String email, String company) {
        AppState retVal = this.applicationState.processActivation(username, email, company);
        if (retVal != null) {
            return ResponseEntity.ok((Object)retVal);
        }
        return this.appStateGet();
    }

    public ResponseEntity<AppState> appStateUsernameEmailPost(String username, String email) {
        return this.appStateUsernameEmailCompanyPost(username, email, null);
    }

    public ResponseEntity<AppState> appStateMailactivationPost(@Valid MailRegistrationData mailRegistrationData) {
        AppState retVal = this.applicationState.processEmailActivation(mailRegistrationData.getData());
        if (retVal != null) {
            return ResponseEntity.ok((Object)retVal);
        }
        return this.appStateGet();
    }

    public ResponseEntity<AppState> appStateMaildeactivationPost(@Valid MailRegistrationData mailRegistrationData) {
        AppState retVal = this.applicationState.processEmailDeactivation(mailRegistrationData.getData());
        if (retVal != null) {
            return ResponseEntity.ok((Object)retVal);
        }
        return this.appStateGet();
    }

    public ResponseEntity<AppState> appStateDeactivatePost() {
        AppState retVal = this.applicationState.processDeactivation();
        if (retVal != null) {
            return ResponseEntity.ok((Object)retVal);
        }
        return this.appStateGet();
    }
}

