/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.service.SearchService;
import com.elexico.genoa.rest.api.EntryCountApi;
import com.elexico.genoa.rest.model.IndexEntries;
import com.elexico.genoa.rest.model.ResultCounter;
import de.edpan.engine.layout.SearchField;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.SearchException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class EntryCountController
implements EntryCountApi {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final List<String> fieldNames = Arrays.asList("HEADWORD_ADVANCED", "INFLECTION", "PHRASEOLOGY", "TRANSLATION", "FULL_TEXT", "TITLE", "KEYWORD", "DE_TEXT", "FR_TEXT");
    @Resource
    private ProductManager productManager;
    @Resource
    private SearchService searchService;

    @PreAuthorize(value="@accessService.hasAccess(#productId)")
    public ResponseEntity<List<ResultCounter>> entryCountProductIdTextGet(String productId, String searchText, @Valid String exclude) {
        this.productManager.setProductContext(productId);
        ArrayList searchFields = new ArrayList(this.productManager.getProductContext().getLayoutProvider().getSearchFields());
        Iterator i = searchFields.iterator();
        while (i.hasNext()) {
            if (fieldNames.contains(((SearchField)i.next()).getField())) continue;
            i.remove();
        }
        ArrayList<ResultCounter> retVal = new ArrayList<ResultCounter>();
        for (SearchField field : searchFields) {
            try {
                IndexEntries searchEntries = this.searchService.searchEntries(productId, 0, 1, null, field.getField(), searchText, exclude);
                ResultCounter resultCounter = new ResultCounter();
                resultCounter.setField(field.getField());
                resultCounter.setText(field.getKey());
                resultCounter.setCount(searchEntries.getTotalCount());
                retVal.add(resultCounter);
            }
            catch (SearchException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return ResponseEntity.ok(retVal);
    }
}

