/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.service.IndexEntriesService;
import com.elexico.genoa.rest.api.IndexEntryApi;
import com.elexico.genoa.rest.model.IndexEntry;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class IndexEntryController
implements IndexEntryApi {
    @Resource
    private IndexEntriesService indexEntriesService;

    @PreAuthorize(value="@accessService.hasAccess(#productId)")
    public ResponseEntity<IndexEntry> indexEntryProductIdSearchStringGet(String productId, String search, @Min(value=0L) @Max(value=3L) @Valid @Min(value=0L) @Max(value=3L) @Valid Integer language) {
        IndexEntry indexEntry = this.indexEntriesService.getIndexEntry(productId, search, language);
        if (indexEntry != null) {
            return ResponseEntity.ok().body((Object)indexEntry);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

