/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.rest.api.ProductInfoApi;
import com.elexico.genoa.rest.model.ProductDescriptor;
import com.elexico.genoa.rest.model.ProductDescriptorEntries;
import com.elexico.genoa.rest.model.ProductInfo;
import com.elexico.genoa.rest.model.SearchField;
import de.edpan.engine.layout.LayoutProvider;
import de.edpan.engine.layout.ViewProvider;
import de.edpan.engine.layout.impl.TextSearchFieldWithOptions;
import de.edpan.engine.product.ProductManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class ProductInfoController
implements ProductInfoApi {
    @Resource
    private Locale defaultLocale;
    @Resource
    private ProductManager productManager;
    @Resource
    private MessageSource messageSource;

    public ResponseEntity<ProductInfo> productInfoProductIdGet(String productId) {
        List searchFields;
        de.edpan.engine.product.ProductInfo productInfo = this.productManager.getProductInfo(productId);
        if (productInfo == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        ProductInfo retVal = new ProductInfo();
        retVal.setProductId(productInfo.getProductKey());
        retVal.setResourceKey(productInfo.getResourceKey());
        retVal.setSortOrder(productInfo.getSortOrder());
        retVal.setTestLicenseMaxAccess(Integer.valueOf(productInfo.getTestLicenseMaxAccess()));
        retVal.setLanguage1(productInfo.getLanguage1());
        retVal.setLanguage2(productInfo.getLanguage2());
        retVal.setFirstEntry(productInfo.getFirstEntry());
        retVal.setProductVersion(productInfo.getProductVersion());
        retVal.setDataSetVersion(productInfo.getDataSetVersion());
        retVal.setSoftwareVersion(productInfo.getSoftwareVersion());
        com.elexico.genoa.rest.model.LayoutProvider lp = new com.elexico.genoa.rest.model.LayoutProvider();
        retVal.setLayoutProvider(lp);
        LayoutProvider layoutProvider = productInfo.getLayoutProvider();
        lp.setCssPaths(layoutProvider.getCssPaths());
        lp.setImagePath(layoutProvider.getImagePath());
        lp.setShowDetailSearch(Boolean.valueOf(layoutProvider.isShowDetailSearch()));
        ViewProvider viewProvider = layoutProvider.getViewProvider();
        if (viewProvider != null) {
            lp.setGrid(viewProvider.getView("grid"));
        }
        List sfs = (searchFields = layoutProvider.getSearchFields()).isEmpty() ? Collections.emptyList() : new ArrayList(searchFields.size());
        for (de.edpan.engine.layout.SearchField searchField : searchFields) {
            SearchField sf = new SearchField();
            sf.setKey(searchField.getKey());
            sf.setField(searchField.getField());
            sf.setToggle(searchField.getToggle());
            if (searchField instanceof TextSearchFieldWithOptions) {
                sf.setOptions(((TextSearchFieldWithOptions)searchField).getOptionFile());
            }
            sfs.add(sf);
        }
        lp.setSearchFields(sfs);
        return ResponseEntity.ok((Object)retVal);
    }

    public ResponseEntity<ProductDescriptorEntries> productInfoListGet() {
        List productInfos = this.productManager.getProductInfos();
        ProductDescriptorEntries productDescriptorEntries = new ProductDescriptorEntries();
        for (de.edpan.engine.product.ProductInfo productInfo : productInfos) {
            ProductDescriptor descriptor = new ProductDescriptor();
            String productKey = productInfo.getProductKey();
            descriptor.setId(productKey);
            String key = "product.title." + productKey;
            String title = this.messageSource.getMessage(key, null, key, this.defaultLocale);
            descriptor.setTitle(title);
            descriptor.setSort(productInfo.getSortOrder());
            productDescriptorEntries.addEntriesItem(descriptor);
        }
        productDescriptorEntries.setTotalCount(Integer.valueOf(productInfos.size()));
        return ResponseEntity.ok((Object)productDescriptorEntries);
    }
}

