/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.backend.service.SearchService;
import com.elexico.genoa.rest.api.SearchApi;
import com.elexico.genoa.rest.model.AdvancedQuery;
import com.elexico.genoa.rest.model.IndexEntries;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.SearchException;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/rest"})
public class SearchController
implements SearchApi {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private ProductManager productManager;
    @Resource
    private SearchService searchService;

    @PreAuthorize(value="@accessService.hasAccess(#advancedQuery.productId)")
    public ResponseEntity<IndexEntries> searchPost(AdvancedQuery advancedQuery) {
        IndexEntries searchEntries = null;
        try {
            searchEntries = this.searchService.searchEntries(advancedQuery.getProductId(), advancedQuery.getStart().intValue(), advancedQuery.getCount().intValue(), advancedQuery.getLanguage(), advancedQuery.getSearchFields());
        }
        catch (SearchException e) {
            throw new ResponseStatusException(HttpStatus.NOT_ACCEPTABLE, "lucene.too.many.clauses", (Throwable)e);
        }
        return ResponseEntity.ok((Object)searchEntries);
    }
}

