/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.controller;

import com.elexico.genoa.rest.api.UserregistrationApi;
import com.elexico.genoa.rest.model.PasswordChangeData;
import com.elexico.genoa.rest.model.PasswordRequestData;
import com.elexico.genoa.rest.model.RegistrationError;
import com.elexico.genoa.rest.model.RegistrationResponse;
import com.elexico.genoa.rest.model.UserRegistrationData;
import de.edpan.engine.user.AuthenticationException;
import de.edpan.engine.user.ChangePasswordData;
import de.edpan.engine.user.ChangePasswordService;
import de.edpan.engine.user.RegistrationData;
import de.edpan.engine.user.RegistrationDataImpl;
import de.edpan.engine.user.RegistrationException;
import de.edpan.engine.user.RegistrationManager;
import de.edpan.engine.user.User;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import javax.persistence.NoResultException;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class UserregistrationController
implements UserregistrationApi {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private RegistrationManager registrationManager;
    @Resource
    private ChangePasswordService changePasswordService;

    public ResponseEntity<RegistrationResponse> userregistrationRegisterPost(@Valid UserRegistrationData rd) {
        RegistrationData registrationData = this.asTransferObject(rd);
        try {
            String lang = rd.getInterfaceLanguage().toString();
            User user = this.registrationManager.registerUser(rd.getProduct(), "standard", lang, registrationData);
            RegistrationResponse body = new RegistrationResponse();
            body.setUserId(Integer.valueOf(user.getUserId()));
            return ResponseEntity.ok().body((Object)body);
        }
        catch (RegistrationException e) {
            LOG.error((Object)((Object)((Object)e)).getClass().getName());
            RegistrationError registrationError = new RegistrationError();
            registrationError.setException(((Object)((Object)e)).getClass().getName());
            registrationError.setCode(e.getErrorCode());
            ResponseEntity response = new ResponseEntity((Object)registrationError, HttpStatus.UNPROCESSABLE_ENTITY);
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<Void> userregistrationRequestNewPasswordPost(@Valid PasswordRequestData passwordRequestData) {
        @NotNull String email = passwordRequestData.getEmail();
        try {
            String language = passwordRequestData.getInterfaceLanguage().toString();
            this.changePasswordService.initiateForgottenPassword(passwordRequestData.getBaseURL(), null, language, email);
            LOG.info((Object)("New password requested for " + email));
        }
        catch (AuthenticationException | NoResultException e) {
            LOG.info((Object)("User not found - " + email));
        }
        catch (Exception e) {
            LOG.error((Object)(e.getMessage() + " " + email), (Throwable)e);
        }
        return ResponseEntity.ok().body(null);
    }

    public ResponseEntity<Void> userregistrationChangePasswordPost(@Valid PasswordChangeData changePasswordData) {
        ChangePasswordData cpd = new ChangePasswordData();
        cpd.setPassword(changePasswordData.getNewPassword());
        cpd.setConfirmpassword(changePasswordData.getNewPassword());
        cpd.setHash(changePasswordData.getHash());
        cpd.setUser(changePasswordData.getUserId());
        cpd.setStamptime(changePasswordData.getStamptime());
        try {
            this.changePasswordService.changePassword(cpd);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (AuthenticationException e) {
            LOG.warn((Object)(e.getMessage() + " " + changePasswordData.getUserId()));
            RegistrationError registrationError = new RegistrationError();
            registrationError.setException(((Object)((Object)e)).getClass().getName());
            ResponseEntity response = new ResponseEntity((Object)registrationError, HttpStatus.NOT_FOUND);
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private RegistrationData asTransferObject(@Valid UserRegistrationData rd) {
        RegistrationDataImpl rdi = new RegistrationDataImpl();
        rdi.setCreateNewAccount(rd.getCreateNewAccount().booleanValue());
        rdi.setEmail(rd.getEmail());
        rdi.setLogin(rd.getEmail());
        rdi.setConfirmemail(rd.getEmail());
        rdi.setFirstname(rd.getFirstName());
        rdi.setLastname(rd.getLastName());
        rdi.setPassword(rd.getPassword());
        rdi.setPersonaldataAccept(rd.getPersonalDataAccept() != false ? "1" : "0");
        rdi.setPersonaltransferdataAccept(rd.getPersonalDataTransferAccept() != false ? "1" : "0");
        rdi.setSerialnumber(rd.getSerialNumber());
        rdi.setBaseURL(rd.getBaseURL());
        return rdi;
    }
}

