/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.security.electron;

import com.elexico.genoa.backend.security.electron.ApplicationState;
import com.elexico.genoa.rest.model.AppState;
import de.pansoft.lm.spi.activation.ActivationFailedException;
import de.pansoft.lm.spi.activation.DeactivationFailedException;
import de.pansoft.lm.spi.activation.MailActivator;
import de.pansoft.lm.spi.activation.OnlineActivator;
import de.pansoft.lm.spi.activation.TooManyCopiesException;
import de.pansoft.lm.spi.license.License;
import de.pansoft.lm.spi.license.LicenseFactory;
import de.pansoft.lm.spi.lock.LockManager;
import de.pansoft.lm.spi.serialNumber.SerialNumberVerifier;
import de.pansoft.lm.spi.serialNumber.SerialNumberVerifierFactory;
import de.pansoft.lm.spi.store.SecureStore;
import de.pansoft.lm.spi.store.SecureStoreFactory;
import de.pansoft.lm.spi.userData.UserData;
import de.pansoft.lm.spi.util.ServiceLocator;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApplicationState {
    private static Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String MAIL_REQUEST_ENCODING = "ISO-8859-1";
    private static final String MAIL_MARKER_START = "a87bl";
    private static final String MAIL_MARKER_END = "6uzKe";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    @Value(value="${genoa.activation.url}")
    private String activationUrl;

    public boolean needsSerial() {
        String prop = LicenseFactory.getInstance().getLicense().getProperty("license.needsSerialNumber");
        boolean needsSerial = Boolean.valueOf(prop);
        return needsSerial;
    }

    public boolean hasSerial() {
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        String serial = secureStore.getProperty("license.serialNumber");
        SerialNumberVerifier verifier = SerialNumberVerifierFactory.getInstance().getSerialNumberVerifier();
        return verifier.verifySerialNumber(serial);
    }

    public boolean isTestLicense() {
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        String serial = secureStore.getProperty("license.serialNumber");
        SerialNumberVerifier verifier = SerialNumberVerifierFactory.getInstance().getSerialNumberVerifier();
        return verifier.isTestSN(serial);
    }

    public boolean needsActivation() {
        LicenseFactory.getInstance().refresh();
        License license = LicenseFactory.getInstance().getLicense();
        String prop = license.getProperty("license.needsActivation");
        boolean needsActivation = Boolean.valueOf(prop);
        if (needsActivation) {
            String activation = license.getProperty("license.activation");
            return activation == null;
        }
        return false;
    }

    public boolean isTestPeriodExpired() {
        if (!this.isTestLicense()) {
            return false;
        }
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        long end = Long.parseLong(secureStore.getProperty("secureStore.testPeriodEnd"));
        return end < System.currentTimeMillis();
    }

    public GracePeriod gracePeriod() {
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        License license = LicenseFactory.getInstance().getLicense();
        Integer remainingDays = null;
        String gracePeriodActivation = license.getProperty("license.gracePeriodActivation");
        GracePeriod retVal = new GracePeriod(this);
        if (gracePeriodActivation != null) {
            int gracePeriod;
            retVal.total = gracePeriod = Integer.parseInt(gracePeriodActivation);
            long now = System.currentTimeMillis();
            String lastStart = secureStore.getProperty("secureStore.lastStart");
            if (lastStart == null) {
                lastStart = Long.toString(now);
                secureStore.setProperty("secureStore.lastStart", lastStart);
            } else {
                long ls = Long.parseLong(lastStart);
                if (ls > now) {
                    remainingDays = 0;
                } else {
                    lastStart = Long.toString(now);
                    secureStore.setProperty("secureStore.lastStart", lastStart);
                }
            }
            if (remainingDays == null) {
                String firstStart = secureStore.getProperty("secureStore.firstStart");
                if (firstStart == null) {
                    firstStart = Long.toString(now);
                    secureStore.setProperty("secureStore.firstStart", firstStart);
                }
                long fs = Long.parseLong(firstStart);
                int diffDays = (int)((now - fs) / 86400000L);
                remainingDays = gracePeriod - diffDays;
                retVal.remaning = remainingDays;
            }
        }
        return retVal;
    }

    public GracePeriod testPeriodRemaining() {
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        License license = LicenseFactory.getInstance().getLicense();
        long _end = Long.parseLong(secureStore.getProperty("secureStore.testPeriodEnd"));
        long _now = System.currentTimeMillis();
        LocalDate end = Instant.ofEpochMilli(_end).atZone(ZoneId.systemDefault()).toLocalDate();
        long between = _end > _now ? ChronoUnit.DAYS.between(LocalDate.now(), end) - 1L : 0L;
        int duration = Integer.parseInt(license.getProperty("license.testPeriod", "1"));
        GracePeriod gp = new GracePeriod(this, duration, (int)between);
        return gp;
    }

    public AppState processSerialNumber(String serialNumber) {
        boolean hasSerial = this.hasSerial();
        boolean isTestLicense = hasSerial ? this.isTestLicense() : false;
        boolean isTestExpired = isTestLicense ? this.isTestPeriodExpired() : true;
        AppState retVal = new AppState();
        retVal.command(isTestLicense ? AppState.CommandEnum.CONFIRM_TEST : AppState.CommandEnum.SEND_SERIAL);
        retVal.flow(isTestExpired ? AppState.FlowEnum.REQUIRED : AppState.FlowEnum.OPTIONAL);
        retVal.setCanActivate(Boolean.valueOf(false));
        if (isTestLicense) {
            GracePeriod gp = this.testPeriodRemaining();
            retVal.setGracePeriod(Integer.valueOf(gp.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gp.getRemaning()));
        }
        License license = LicenseFactory.getInstance().getLicense();
        SecureStore secureStore = SecureStoreFactory.getInstance().getSecureStore();
        SerialNumberVerifier serialNumberVerifier = SerialNumberVerifierFactory.getInstance().getSerialNumberVerifier();
        if (!serialNumberVerifier.verifySerialNumber(serialNumber)) {
            retVal.workflowError(AppState.WorkflowErrorEnum.INVALID_SERIAL);
            return retVal;
        }
        boolean isTestSN = serialNumberVerifier.isTestSN(serialNumber);
        if (isTestSN) {
            if (secureStore.getProperty("license.serialNumber") != null) {
                retVal.workflowError(AppState.WorkflowErrorEnum.ALREADY_TESTED);
                return retVal;
            }
            int testPeriod = Integer.parseInt(license.getProperty("license.testPeriod"));
            GregorianCalendar now = (GregorianCalendar)GregorianCalendar.getInstance();
            GregorianCalendar end = new GregorianCalendar(now.get(1), now.get(2), now.get(5) + 1 + testPeriod);
            secureStore.setProperty("secureStore.testPeriodEnd", Long.toString(end.getTimeInMillis()));
            secureStore.setProperty("secureStore.isTestLicense", Boolean.toString(isTestSN));
            secureStore.setProperty("license.serialNumber", serialNumber);
            return null;
        }
        if (!serialNumberVerifier.isDownloadSN(serialNumber)) {
            retVal.workflowError(AppState.WorkflowErrorEnum.NOT_A_DOWNLOAD_SERIAL);
            return retVal;
        }
        secureStore.setProperty("secureStore.isTestLicense", Boolean.toString(isTestSN));
        secureStore.setProperty("license.serialNumber", serialNumber);
        return null;
    }

    public AppState processActivation(String username, String email, String company) {
        AppState retVal = null;
        OnlineActivator activator = (OnlineActivator)ServiceLocator.getInstance().getService(OnlineActivator.class);
        UserData userData = new UserData();
        userData.setLastName(username);
        userData.setEmail(email);
        userData.setCompany(company);
        try {
            String target = this.activationUrl;
            activator.activate(userData, target);
        }
        catch (TooManyCopiesException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.ABORT);
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.TOO_MANY_ACTIVATIONS);
            retVal.flow(AppState.FlowEnum.REQUIRED);
            retVal.canActivate(Boolean.valueOf(true));
            LOG.info((Object)e);
        }
        catch (ActivationFailedException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.CONFIRM_ACTIVATION);
            retVal.flow(AppState.FlowEnum.MAY_RETRY);
            GracePeriod gracePeriod = this.gracePeriod();
            retVal.setGracePeriod(Integer.valueOf(gracePeriod.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gracePeriod.getRemaning()));
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.ACTIVATION_FAILED);
            retVal.setFailedRequest(e.getRequest() + e.getProduct());
            retVal.canActivate(Boolean.valueOf(true));
            LOG.warn((Object)e);
        }
        return retVal;
    }

    public AppState processEmailDeactivation(String data) {
        data = this.removeMarker(data);
        AppState retVal = new AppState();
        MailActivator activator = (MailActivator)ServiceLocator.getInstance().getService(MailActivator.class);
        try {
            activator.deactivate(data.getBytes(MAIL_REQUEST_ENCODING));
            this.handleDeactivaionSuccess(retVal);
        }
        catch (DeactivationFailedException e) {
            this.handleDeactivationFailed(retVal, e);
        }
        catch (UnsupportedEncodingException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.ABORT);
            retVal.flow(AppState.FlowEnum.MAY_RETRY);
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.DEACTIVATION_FAILED);
            retVal.canActivate(Boolean.valueOf(true));
            GracePeriod gracePeriod = this.gracePeriod();
            retVal.setGracePeriod(Integer.valueOf(gracePeriod.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gracePeriod.getRemaning()));
            LOG.info((Object)e);
        }
        return retVal;
    }

    private void handleDeactivaionSuccess(AppState retVal) {
        retVal.flow(AppState.FlowEnum.REQUIRED);
        retVal.command(AppState.CommandEnum.CLOSE_APP);
        retVal.canActivate(Boolean.valueOf(false));
        retVal.canDeactivate(Boolean.valueOf(false));
    }

    private void handleDeactivationFailed(AppState retVal, DeactivationFailedException e) {
        retVal.command(AppState.CommandEnum.ABORT);
        retVal.setWorkflowError(AppState.WorkflowErrorEnum.DEACTIVATION_FAILED);
        retVal.flow(AppState.FlowEnum.PROCEED);
        retVal.canDeactivate(Boolean.valueOf(true));
        retVal.setFailedRequest(e.getRequest() + e.getProduct());
        LOG.info((Object)e);
    }

    public AppState processEmailActivation(String data) {
        data = this.removeMarker(data);
        AppState retVal = null;
        MailActivator activator = (MailActivator)ServiceLocator.getInstance().getService(MailActivator.class);
        try {
            activator.activate(data.getBytes(MAIL_REQUEST_ENCODING));
        }
        catch (TooManyCopiesException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.ABORT);
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.TOO_MANY_ACTIVATIONS);
            retVal.flow(AppState.FlowEnum.REQUIRED);
            retVal.canActivate(Boolean.valueOf(true));
            LOG.info((Object)e);
        }
        catch (ActivationFailedException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.CONFIRM_ACTIVATION);
            retVal.flow(AppState.FlowEnum.MAY_RETRY);
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.ACTIVATION_FAILED);
            retVal.canActivate(Boolean.valueOf(true));
            GracePeriod gracePeriod = this.gracePeriod();
            retVal.setGracePeriod(Integer.valueOf(gracePeriod.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gracePeriod.getRemaning()));
            retVal.setFailedRequest(e.getRequest() + e.getProduct());
            LOG.warn((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            retVal = new AppState();
            retVal.command(AppState.CommandEnum.ABORT);
            retVal.flow(AppState.FlowEnum.MAY_RETRY);
            retVal.setWorkflowError(AppState.WorkflowErrorEnum.ACTIVATION_FAILED);
            retVal.canActivate(Boolean.valueOf(true));
            GracePeriod gracePeriod = this.gracePeriod();
            retVal.setGracePeriod(Integer.valueOf(gracePeriod.getTotal()));
            retVal.setGracePeriodRemaining(Integer.valueOf(gracePeriod.getRemaning()));
            LOG.info((Object)e);
        }
        return retVal;
    }

    private String removeMarker(String data) {
        data = data.replaceAll("\n", "");
        LOG.info((Object)("received: " + data));
        int start = data.indexOf(MAIL_MARKER_START) + MAIL_MARKER_START.length();
        int end = data.indexOf(MAIL_MARKER_END);
        if (start < 0 || end < 0 || end < start) {
            LOG.info((Object)"data invalid");
        }
        data = data.substring(start, end);
        return data;
    }

    public void setActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
    }

    public AppState processDeactivation() {
        AppState retVal = new AppState();
        OnlineActivator activator = (OnlineActivator)ServiceLocator.getInstance().getService(OnlineActivator.class);
        try {
            activator.deactivate(this.activationUrl);
            this.handleDeactivaionSuccess(retVal);
        }
        catch (DeactivationFailedException e) {
            this.handleDeactivationFailed(retVal, e);
        }
        return retVal;
    }

    public boolean canAccessController() {
        if (!this.needsSerial()) {
            return true;
        }
        if (!this.isLockDataValid()) {
            return false;
        }
        if (this.isTestLicense()) {
            return !this.isTestPeriodExpired();
        }
        if (!this.needsActivation()) {
            return true;
        }
        return this.gracePeriod().getRemaning() > 0;
    }

    public boolean isLockDataValid() {
        License license = LicenseFactory.getInstance().getLicense();
        LockManager lockManager = (LockManager)ServiceLocator.getInstance().getService(LockManager.class);
        boolean lockDataVaild = lockManager.validateLockData(license);
        return lockDataVaild;
    }
}

