/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.security.electron;

import com.elexico.genoa.backend.security.electron.ElectronAuthentication;
import com.elexico.genoa.backend.security.electron.LicenseManagerInitializer;
import de.edpan.lucene.EncryptionUtil;
import de.pansoft.lm.spi.util.ServiceLocator;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class LicenseFilter
extends GenericFilterBean {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Value(value="${genoa.products.datadir}")
    private File dataDir;
    @Value(value="${genoa.products.licensedir}")
    private File licenseDir;
    @Value(value="${genoa.products.product}")
    private String product;
    private static final Authentication AUTHENTICATION = new ElectronAuthentication();
    @Resource
    private EncryptionUtil encryptionUtil;
    @Resource
    private ApplicationContext applicationContext;

    protected void initFilterBean() throws ServletException {
        LicenseManagerInitializer lmi = new LicenseManagerInitializer(this.dataDir, this.licenseDir, this.product);
        try {
            ServiceLocator.getInstance().setApplicationContext(this.applicationContext);
            lmi.init();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this._doFilter(request, response, chain);
            chain.doFilter(request, response);
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void _doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        res.setHeader("Access-Control-Allow-Origin", "*");
        SecurityContext secCxt = SecurityContextHolder.getContext();
        Authentication auth = secCxt.getAuthentication();
        if (auth == null) {
            secCxt.setAuthentication(AUTHENTICATION);
        }
    }
}

