/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.security.electron;

import de.pansoft.lm.impl.directory.EdPanDirectoryLocator;
import de.pansoft.lm.impl.store.BundleReader;
import de.pansoft.lm.spi.directory.DirectoryLocator;
import de.pansoft.lm.spi.license.LKProvider;
import de.pansoft.lm.spi.security.CryptorFactory;
import de.pansoft.lm.spi.util.ServiceLocator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LicenseManagerInitializer
implements LKProvider {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private File dataDir;
    private File licenseDir;
    private String product;
    private String luceneKey = "0";

    public LicenseManagerInitializer(File dataDir, File licenseDir, String product) {
        this.dataDir = dataDir;
        this.licenseDir = licenseDir;
        this.product = product;
    }

    private void updateBCProvider() {
        boolean hasBCProvider = false;
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getName().equals("BC")) continue;
            hasBCProvider = true;
            break;
        }
        if (!hasBCProvider) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private void updateLuceneKey() throws IOException {
        File productDir = new File(this.dataDir, this.product);
        URL conf = Paths.get(this.licenseDir.getAbsolutePath(), this.product, "conf.dat").toFile().toURI().toURL();
        URL product = new File(productDir, "/images/product.png").toURI().toURL();
        this.luceneKey = BundleReader.getLuceneKey((URL)product, (URL)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrivateKey() throws IOException, ClassNotFoundException {
        block6: {
            File keyFile;
            block5: {
                boolean mkdirs;
                Path keyFileDirPath = Paths.get(System.getProperty("user.home"), ".elexico", this.product, "workspace", ".metadata", ".plugins", "edPan.licenseManager");
                File keyfileDir = keyFileDirPath.toFile();
                if (!keyfileDir.exists() && !(mkdirs = keyfileDir.mkdirs())) {
                    throw new FileNotFoundException("Failed to create directory " + keyfileDir);
                }
                keyFile = keyFileDirPath.resolve("key.dat").toFile();
                ObjectInputStream ois = null;
                if (!keyFile.exists()) break block5;
                FileInputStream in = null;
                try {
                    in = new FileInputStream(keyFile);
                    ois = new ObjectInputStream(in);
                    Key key = (Key)ois.readObject();
                    CryptorFactory.getInstance().setPrivateKey(key);
                }
                catch (Throwable throwable) {
                    this.close(ois);
                    this.close((Closeable)in);
                    throw throwable;
                }
                this.close((Closeable)ois);
                this.close((Closeable)in);
                break block6;
            }
            Key key = CryptorFactory.getInstance().generatePrivateKey();
            CryptorFactory.getInstance().setPrivateKey(key);
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                fos = new FileOutputStream(keyFile);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(key);
                oos.flush();
            }
            catch (Throwable throwable) {
                this.close(oos);
                this.close((Closeable)fos);
                throw throwable;
            }
            this.close((Closeable)oos);
            this.close((Closeable)fos);
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init() throws ClassNotFoundException, IOException {
        this.updateBCProvider();
        this.updatePrivateKey();
        this.updateLuceneKey();
        ServiceLocator serviceLocator = ServiceLocator.getInstance();
        serviceLocator.getServiceContext().put("lucene.key", Long.valueOf(this.luceneKey));
        System.setProperty("lucene.key", this.luceneKey);
        serviceLocator.registerService(DirectoryLocator.class, EdPanDirectoryLocator.class);
    }

    public String getKey() {
        return this.luceneKey;
    }
}

