/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.service.impl;

import com.elexico.genoa.backend.service.DetailEntryService;
import com.elexico.genoa.rest.model.DetailEntry;
import de.edpan.engine.product.ProductContext;
import de.edpan.engine.product.ProductInfo;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.IndexEntry;
import de.edpan.engine.search.Query;
import de.edpan.engine.search.SearchSession;
import de.edpan.xml.transformer.HTMLTransformer;
import de.pansoft.edpan.web.util.LocaleContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Resource;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class DetailEntryServiceImpl
implements DetailEntryService {
    private static final Log LOG = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Resource
    private ProductManager productManager;
    @Resource
    private SearchSession searchSession;

    public Optional<DetailEntry> getDetailEntry(String productId, String entryId, Integer idx, Query query, Locale interfaceLanguage) {
        ProductInfo productInfo = this.productManager.getProductInfo(productId);
        String content = null;
        String firstHighlighted = null;
        String title = null;
        int language = -1;
        LocaleContext.setLocale((Locale)interfaceLanguage);
        DetailEntry retVal = null;
        try {
            int i;
            this.productManager.setProductContext(productInfo.getProductKey());
            de.edpan.engine.search.DetailEntry entry = this.productManager.getProductContext().getSearchProvider().getDetailEntryProvider().get(entryId, query, interfaceLanguage);
            title = entry.getText();
            language = entry.getLanguage().getIndex();
            content = this.transformXmlContent(entry);
            this.searchSession.setIndexEntry((IndexEntry)entry);
            if (idx != null) {
                this.searchSession.setAdvancedSearchIdx(idx);
            }
            if ((i = content.indexOf("id=\"hl_")) > -1) {
                i = content.indexOf("\"", i) + 1;
                firstHighlighted = content.substring(i, content.indexOf("\"", i + 1));
            }
            retVal = new DetailEntry();
            retVal.setId(entryId);
            retVal.setTitle(title);
            retVal.setContent(content);
            retVal.setLanguage(Integer.valueOf(language));
            retVal.setScrollTo(firstHighlighted);
            retVal.setAggregateIndex(Integer.valueOf(entry.getAggregateIndex()));
        }
        catch (IOException | TransformerException e) {
            String message = "failed to transform %s product: %s lang: %s query: %s";
            message = String.format(message, entryId, productId, interfaceLanguage, query);
            LogFactory.getLog(this.getClass()).error((Object)message, (Throwable)e);
        }
        return Optional.ofNullable(retVal);
    }

    private String transformXmlContent(de.edpan.engine.search.DetailEntry detailEntry) throws TransformerException {
        int lang = detailEntry.getLanguage().getIndex();
        String s = detailEntry.getXMLContent();
        StringBuffer myS = null;
        HashMap<String, String> langStrings = new HashMap<String, String>();
        langStrings.put("view.details.base", "");
        String id = detailEntry.getId();
        langStrings.put("view.details.id", id);
        if (lang == 2) {
            langStrings.put("view.details.headimage", "flag_lang2_22_16.gif");
            langStrings.put("entry.language", "seconda_lingua");
        } else if (lang == 1) {
            langStrings.put("view.details.headimage", "flag_lang1_22_16.gif");
            langStrings.put("entry.language", "prima_lingua");
        } else {
            langStrings.put("view.details.headimage", "flag_null.gif");
            langStrings.put("entry.language", "nessuna_lingua");
        }
        langStrings.put("historyHasPrevious", Boolean.TRUE.toString());
        langStrings.put("historyHasNext", Boolean.TRUE.toString());
        s = s.replaceAll("\\\\u([A-Fa-f0-9]{4})", "&#x$1;");
        ProductContext productContext = this.productManager.getProductContext();
        HTMLTransformer htmlTrans = productContext.getHtmlTransformer();
        myS = htmlTrans.transform2HTML(s, langStrings);
        return myS.toString();
    }
}

