/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.service.impl;

import com.elexico.genoa.backend.service.IndexEntriesService;
import com.elexico.genoa.backend.service.util.EntryProviderUtil;
import com.elexico.genoa.backend.service.util.LanguageUtil;
import com.elexico.genoa.rest.model.IndexEntries;
import de.edpan.engine.product.ProductInfo;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.EntryProvider;
import de.edpan.engine.search.IndexEntry;
import de.edpan.engine.search.IndexEntryProvider;
import de.edpan.engine.search.Language;
import de.edpan.engine.search.SearchProvider;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IndexEntriesServiceImpl
implements IndexEntriesService {
    @Resource
    private ProductManager productManager;

    public IndexEntries getIndexEntries(String product, int start, int count, Integer language) {
        ProductInfo productInfo = this.productManager.getProductInfo(product);
        Language[] languages = LanguageUtil.getLanguages((Integer)language, (ProductInfo)productInfo);
        this.productManager.setProductContext(product);
        IndexEntryProvider indexEntryProvider = this.productManager.getProductContext().getSearchProvider().getIndexEntryProvider(languages);
        IndexEntries entries = EntryProviderUtil.readEntries((EntryProvider)indexEntryProvider, (int)start, (int)count);
        return entries;
    }

    public com.elexico.genoa.rest.model.IndexEntry getIndexEntry(String product, String search, Integer language) {
        ProductInfo productInfo = this.productManager.getProductInfo(product);
        Language[] languages = LanguageUtil.getLanguages((Integer)language, (ProductInfo)productInfo);
        com.elexico.genoa.rest.model.IndexEntry retVal = null;
        this.productManager.setProductContext(product);
        SearchProvider searchProvider = this.productManager.getProductContext().getSearchProvider();
        IndexEntry entry = (IndexEntry)searchProvider.getIndexEntryProvider(languages).get(search);
        if (entry != null) {
            retVal = new com.elexico.genoa.rest.model.IndexEntry();
            retVal.setId(entry.getId());
            retVal.setLanguage(Integer.valueOf(entry.getLanguage().getIndex()));
            retVal.setQuery(search);
            retVal.setAggregateIndex(Integer.valueOf(entry.getAggregateIndex()));
            retVal.setLanguageIndex(Integer.valueOf(entry.getLanguageIndex()));
        }
        return retVal;
    }
}

