/*
 * Decompiled with CFR 0.152.
 */
package com.elexico.genoa.backend.service.impl;

import com.elexico.genoa.backend.service.SearchService;
import com.elexico.genoa.backend.service.util.EntryProviderUtil;
import com.elexico.genoa.backend.service.util.LanguageUtil;
import com.elexico.genoa.rest.model.IndexEntries;
import de.edpan.engine.layout.SearchField;
import de.edpan.engine.product.ProductInfo;
import de.edpan.engine.product.ProductManager;
import de.edpan.engine.search.EntryProvider;
import de.edpan.engine.search.Language;
import de.edpan.engine.search.Query;
import de.edpan.engine.search.SearchEntryProvider;
import de.edpan.engine.search.SearchException;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    @Resource
    private ProductManager productManager;

    public IndexEntries searchEntries(String product, int start, int count, Integer language, Map<String, String> searchFields) throws SearchException {
        Query query = new Query();
        this.productManager.setProductContext(product);
        for (SearchField searchField : this.productManager.getProductContext().getLayoutProvider().getSearchFields()) {
            String fieldName = searchField.getField();
            String fieldValue = searchFields.get(fieldName);
            if (fieldValue == null) continue;
            query.putQueryOption(fieldName, fieldValue);
        }
        IndexEntries entries = this.advancedSearch(query, product, start, count, language);
        return entries;
    }

    public IndexEntries searchEntries(String product, int start, int count, Integer language, String fieldName, String fieldValue, String exclude) throws SearchException {
        this.productManager.setProductContext(product);
        Query query = new Query();
        query.putQueryOption(fieldName, fieldValue);
        if (exclude != null) {
            query.putQueryOption("ID", "!" + exclude);
        }
        IndexEntries entries = this.advancedSearch(query, product, start, count, language);
        return entries;
    }

    private IndexEntries advancedSearch(Query query, String productKey, int start, int count, Integer language) throws SearchException {
        String Keyword;
        ProductInfo productInfo = this.productManager.getProductInfo(productKey);
        if ((productKey.matches("hpcol20") || productKey.matches("hpmic") || productKey.matches("hpmim")) && query != null && query.toString().length() > 0 && (Keyword = query.getQueryOption("HEADWORD_ADVANCED")) != "" && Keyword != null && !Keyword.contains("&") && !Keyword.contains("#") && !Keyword.contains("\"") && Keyword.contains(" ")) {
            Keyword = Keyword.replaceAll("  ", " ");
            Keyword = Keyword.replaceAll(" ", " # ");
            query.putQueryOption("HEADWORD_ADVANCED", Keyword);
        }
        if ((productKey.matches("hp4c") || productKey.matches("hpcc") || productKey.matches("hpcp")) && query != null && query.toString().length() > 0) {
            String CodeNumber;
            if (query.getQueryOption("FULL_TEXT") == null && query.getQueryOption("TITLE") == null && query.getQueryOption("ARTICLE") == null) {
                query.putQueryOption("ARTICLE", "0");
            }
            if ((CodeNumber = query.getQueryOption("NUMBER")) != "" && CodeNumber != null && CodeNumber.contains("/")) {
                CodeNumber = CodeNumber.replaceAll("/", " && ");
                query.putQueryOption("NUMBER", CodeNumber);
            }
        }
        if ((productKey.matches("hpjap") || productKey.matches("hpcin")) && query != null && query.toString().length() > 0) {
            Object FullTextJap = query.getQueryOption("FULL_TEXT_JAP");
            Object HeadwordJap = query.getQueryOption("HEADWORD_ADVANCED_JAP");
            if (FullTextJap != "" && FullTextJap != null) {
                FullTextJap = "*" + (String)FullTextJap + "*";
                query.putQueryOption("FULL_TEXT_JAP", (String)FullTextJap);
            }
            if (productKey.matches("hpjap") && HeadwordJap != "" && HeadwordJap != null) {
                HeadwordJap = "*" + (String)HeadwordJap + "*";
                query.putQueryOption("HEADWORD_ADVANCED_JAP", (String)HeadwordJap);
            }
        }
        Language[] languages = LanguageUtil.getLanguages((Integer)language, (ProductInfo)productInfo);
        SearchEntryProvider searchEntryProvider = this.productManager.getProductContext().getSearchProvider().getSearchEntryProvider(languages, query);
        IndexEntries entries = EntryProviderUtil.readEntries((EntryProvider)searchEntryProvider, (int)start, (int)count);
        return entries;
    }
}

